<?php

use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Listing\Listing;

defined('ABSPATH') || exit;

$form = new Form( Form::Storage_Meta );
$request = Request::instance();

$listing = new Listing( $request->get('listing_id') );

// valid listing
if( ! $listing->id ) {
    return;
}

$image = $listing->get_first_from_gallery('thumbnail');

// check if owner
if( (int) $listing->post->post_author !== get_current_user_id() ) {
    return;
}

// set global post object
global $post;
$post = get_post( $listing->id, OBJECT );
setup_postdata( $post );

global $ulz_listing;
$ulz_listing = $listing;

?>

<?php Ucore()->the_template('modals/listing'); ?>

<div class="ulz-modal-container ulz-scrollbar">
    <div class="ulz-listing-edit">
        <form class="ulz-form" method="post">
            <div class="ulz-grid">

                <input type="hidden" name="listing_id" value="<?php echo (int) $listing->id; ?>">
                <?php wp_nonce_field( 'utillz_account_listing_update', 'security' ); ?>

                <?php

                    if( ! $listing->get('ulz_listing_type') ) {
                        return;
                    }

                    $form->render([
                        'type' => 'tab',
                        'name' => esc_html__( 'General', 'utillz-core' )
                    ]);

                    $items = Ucore()->jsoning( 'ulz_fields', $listing->get('ulz_listing_type') );

                    foreach( $items as $item ) {
                        if( isset( $item->fields->is_submit_form ) && $item->fields->is_submit_form ) {

                            $field = $form->create( $item );

                            if( ! Ucore()->is_error( $field ) ) {
                                echo $field->get();
                            }
                        }
                    }

                    /*
                     * pricing
                     *
                     */
                    $action_fields = \UtillzCore\Inc\Src\Listing_Type\Action::get_action_fields( $listing->type );
                    $actions = $listing->type->get_action();

                    if( $action_fields->allow_pricing ) {

                        $form->render([
                            'type' => 'tab',
                            'name' => esc_html__( 'Pricing', 'utillz-core' )
                        ]);

                        $form->render([
                            'type' => 'number',
                            'id' => 'ulz_price',
                            'name' => esc_html__('Base Price', 'utillz-core'),
                            'min' => 0,
                            'step' => 0.01,
                            'required' => boolval( ! $action_fields->allow_not_required_price ),
                        ]);

                        if( $action_fields->allow_extra_pricing ) {

                            $form->render([
                                'type' => 'repeater',
                                'id' => 'ulz_extra_pricing',
                                'name' => esc_html__('Add extra service pricing', 'utillz-core'),
                                'button' => [
                                    'label' => esc_html__('Add service', 'utillz-core')
                                ],
                                'templates' => [

                                    /*
                                     * service
                                     *
                                     */
                                    'service' => [
                                        'name' => esc_html__('Service', 'utillz-core'),
                                        'heading' => 'name',
                                        'fields' => [

                                            'name' => [
                                                'type' => 'text',
                                                'name' => esc_html__('Service name', 'utillz-core'),
                                                'placeholder' => esc_html__('Enter service name', 'utillz-core'),
                                                'col' => 4,
                                            ],
                                            'type' => [
                                                'type' => 'select',
                                                'name' => esc_html__('Service type', 'utillz-core'),
                                                'options' => [
                                                    'single_fee' => esc_html__('Single fee', 'utillz-core'),
                                                ],
                                                'allow_empty' => false,
                                                'col' => 4,
                                            ],
                                            'price' => [
                                                'type' => 'number',
                                                'name' => esc_html__('Service price', 'utillz-core'),
                                                'min' => 0,
                                                'step' => 0.01,
                                                'col' => 4,
                                            ],

                                        ]
                                    ],

                                ]
                            ]);

                        }

                        if( $action_fields->allow_addons ) {

                            $form->render([
                                'type' => 'repeater',
                                'id' => 'ulz_addons',
                                'name' => esc_html__('Add addons', 'utillz-core'),
                                'button' => [
                                    'label' => esc_html__('Add addon', 'utillz-core')
                                ],
                                'templates' => [

                                    /*
                                     * addon
                                     *
                                     */
                                    'addon' => [
                                        'name' => esc_html__('Addon', 'utillz-core'),
                                        'heading' => 'name',
                                        'fields' => [

                                            'name' => [
                                                'type' => 'text',
                                                'name' => esc_html__('Addon name', 'utillz-core'),
                                                'placeholder' => esc_html__('Enter addon name', 'utillz-core'),
                                                'col' => 6,
                                            ],
                                            'price' => [
                                                'type' => 'number',
                                                'name' => esc_html__('Addon price', 'utillz-core'),
                                                'min' => 0,
                                                'step' => 0.01,
                                                'col' => 6,
                                            ],
                                            'key' => [
                                                'type' => 'auto-key',
                                                'name' => esc_html__('Addon Id', 'utillz-core'),
                                            ],

                                        ]
                                    ],

                                ]
                            ]);

                        }

                    }

                ?>

            </div>
        </form>
    </div>
</div>

<div class="ulz-modal-footer ulz--top-border ulz-text-center">
    <a href="#" class="ulz-button ulz-button-accent ulz-modal-button" data-action="listing-save">
        <span><?php esc_html_e( 'Save changes', 'utillz-core' ); ?></span>
        <?php Ucore()->preloader(); ?>
    </a>
</div>
<script>
$(document).ready(function() {
    function initUploadFunctionality() {
        $('.ulz-upload-wrapper').each(function() {
            const dropZone = $(this);
            const id = dropZone.data('id');
            const fileInput = $('#ulz-upload-' + id);
            const customBtn = $('#ulz-custom-btn-' + id);

            if (!fileInput.length || !customBtn.length) {
                console.warn('Elements not found for ID:', id);
                return;
            }

            // Unbind any previous click event to prevent duplicate triggering
            customBtn.off('click').on('click', function(e) {
                e.preventDefault();
                fileInput.trigger('click');
            });

            // Handle drag and drop highlighting
            dropZone.off('dragenter dragover').on('dragenter dragover', function(e) {
                e.preventDefault();
                e.stopPropagation();
                dropZone.addClass('dragging');
            });

            dropZone.off('dragleave drop').on('dragleave drop', function(e) {
                e.preventDefault();
                e.stopPropagation();
                dropZone.removeClass('dragging');
            });

            // Handle file drop
            dropZone.off('drop').on('drop', function(e) {
                e.preventDefault();
                e.stopPropagation();
                fileInput.prop('files', e.originalEvent.dataTransfer.files);

                // Trigger a change event
                fileInput.trigger('change');
            });
        });
    }

    // Initialize upload functionality
    initUploadFunctionality(); 
});
</script>